/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package console;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.InputStreamReader;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class ConsoleExample {
    
    public static void prompt(String prompt) {
        //Navigate to source to see what really happens when you print out a message.
        System.out.println(prompt);
    }
    
    public static String accept(){
        
        //Various datatypes that we might have to deal with.
        byte[] bytes= new byte[10];
        char[] chars=new char[10];
        String str="";
        
        //Using System.in to read bytes.
        try {
            InputStreamReader input = new InputStreamReader(System.in);
            BufferedReader stringInput = new BufferedReader(input);
            str=stringInput.readLine();
            System.out.println(str);
        } catch (IOException ex) {
            Logger.getLogger(ConsoleExample.class.getName()).log(Level.SEVERE, null, ex);
        }

        return str;
    }
    
}
